/**
 * @file preload
 *
 * @copyright 2023 Friedrich Luetze GmbH
 *
 * @author Yannik Wicke <Yannik.Wicke@Luetze.de>
 */

const { contextBridge, ipcRenderer } = require("electron");

const electronHandler = {
  ipcRenderer: {
    send(channel, ...args) {
      return ipcRenderer.send(channel, ...args);
    },
    sendSync(channel, ...args) {
      return ipcRenderer.sendSync(channel, ...args);
    },
    on(channel, func) {
      const subscription = (_event, ...args) => func(...args);
      ipcRenderer.on(channel, subscription);

      return () => {
        ipcRenderer.removeListener(channel, subscription);
      };
    },
    off(channel, func) {
      const subscription = (_event, ...args) => func(...args);
      ipcRenderer.off(channel, subscription);
    },
  },
};
contextBridge.exposeInMainWorld("electron", electronHandler);
contextBridge.exposeInMainWorld("env", {
  REACT_APP_API_BASE_URL: process.env.REACT_APP_API_BASE_URL,
  REACT_APP_API_LOGIN_URL: process.env.REACT_APP_API_LOGIN_URL,
  REACT_APP_API_LOCALE_URL: process.env.REACT_APP_API_LOCALE_URL,
});
